<?php

// Mostrar botón de WhatsApp en la página de agradecimiento de WooCommerce
add_action('woocommerce_thankyou', 'woo_add_whatsapp_button', 10, 1);

function woo_add_whatsapp_button($order_id) {
    if (!$order_id) return;

    $order = wc_get_order($order_id);
    if (!$order instanceof WC_Order) return;

    $nombre = $order->get_billing_first_name();
    $numero = $order->get_order_number();
    $total = number_format($order->get_total(), 2, ',', '.') . ' €';

    $productos = [];
    foreach ($order->get_items() as $item) {
        $productos[] = $item->get_name();
    }

    // Mensaje limpio para WhatsApp
    $mensaje = "Hola $nombre, gracias por tu pedido #$numero de " . implode(", ", $productos) . " por un total de $total.\n\n🛍️ ¡Te avisaremos cuando esté listo!\n\n- Equipo de TuTienda";

    $numero_negocio = get_option('woo_whatsapp_number');
    if (!$numero_negocio) return;

    $url = 'https://wa.me/' . preg_replace('/\D+/', '', $numero_negocio) . '?text=' . urlencode($mensaje);

    echo '<p class="woocommerce-message" style="margin-top:20px;">
        <a href="' . esc_url($url) . '" 
           style="display: inline-block; background-color: #25D366; color: white; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: 600;" 
           target="_blank">
           📲 Enviar pedido por WhatsApp
        </a>
    </p>';
}

// Shortcode para mostrar botón en cualquier parte del sitio
add_shortcode('whatsapp_pedido', 'woo_shortcode_whatsapp_button');

function woo_shortcode_whatsapp_button() {
    if (!is_user_logged_in()) return '';

    $user_id = get_current_user_id();
    $orders = wc_get_orders([
        'customer_id' => $user_id,
        'limit'       => 1,
        'orderby'     => 'date',
        'order'       => 'DESC',
    ]);

    if (empty($orders)) return '';

    $order = $orders[0];
    $nombre = $order->get_billing_first_name();
    $numero = $order->get_order_number();
    $total = number_format($order->get_total(), 2, ',', '.') . ' €';

    $productos = [];
    foreach ($order->get_items() as $item) {
        $productos[] = $item->get_name();
    }

    $mensaje = "Hola $nombre, gracias por tu pedido #$numero de " . implode(", ", $productos) . " por un total de $total.\n\n🛍️ ¡Te avisaremos cuando esté listo!\n\n- Equipo de TuTienda";

    $numero_negocio = get_option('woo_whatsapp_number');
    if (!$numero_negocio) return '';

    $url = 'https://wa.me/' . preg_replace('/\D+/', '', $numero_negocio) . '?text=' . urlencode($mensaje);

    return '<p>
        <a href="' . esc_url($url) . '" 
           style="display: inline-block; background-color: #25D366; color: white; padding: 10px 20px; border-radius: 8px; text-decoration: none; font-weight: 600;" 
           target="_blank">
           📲 Enviar pedido por WhatsApp
        </a>
    </p>';
}
