<?php

// Registrar el campo del número de WhatsApp
add_action('admin_init', 'woo_register_whatsapp_settings');
function woo_register_whatsapp_settings() {
    register_setting('woo_whatsapp_settings_group', 'woo_whatsapp_number');

    add_settings_section(
        'woo_whatsapp_section',
        'Ajustes de WhatsApp',
        null,
        'woo_whatsapp_settings_group'
    );
   
}


// Añadir página de opciones al menú de Ajustes
add_action('admin_menu', 'woo_whatsapp_settings_menu');
function woo_whatsapp_settings_menu() {
    add_options_page(
        'Woo WhatsOrder - Ajustes',
        'Woo WhatsOrder',
        'manage_options',
        'woo-whatsapp-settings',
        'woo_whatsapp_settings_page'
    );
}

// Mostrar aviso arriba
add_action('admin_notices', function() {
    if (get_current_screen()->id === 'settings_page_woo-whatsapp-settings') {
        echo '<div class="notice notice-info is-dismissible">
            <p>Configura el número de WhatsApp para Woo WhatsOrder en esta página.</p>
        </div>';
    }
});

// Contenido de la página de ajustes
function woo_whatsapp_settings_page() {
    ?>
   <style>
    .woowhatsorder-wrap {
        max-width: 1000px;
        margin: 0 auto;
        padding: 30px 20px;
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, sans-serif;
    }

    .woowhatsorder-banner {
        margin-bottom: 40px;
        max-height: 300px; /* Altura máxima del contenedor */
        overflow: hidden;
        border-radius: 12px;
        position: relative;
    }

    .woowhatsorder-banner img {
        width: 100%;
        height: auto;
        max-height: 400px; /* Altura máxima de la imagen */
        object-fit: contain; /* Asegura que la imagen se ajuste sin recortar */
        object-position: center;
        display: block;
        margin: 0 auto;
    }

    @media screen and (max-width: 1024px) {
        .woowhatsorder-banner {
            max-height: 30vh; /* Altura relativa en móviles */
        }
        
        .woowhatsorder-banner img {
            max-height: 30vh;
        }
    }

    .woowhatsorder-title {
        color: #1e1e1e;
        font-size: 28px;
        font-weight: 600;
        margin-bottom: 15px;
        padding-bottom: 10px;
        border-bottom: 3px solid #3858e9;
        display: inline-block;
    }

    .woowhatsorder-description {
        color: #3c434a;
        font-size: 16px;
        line-height: 1.6;
        margin-bottom: 25px;
        max-width: 800px;
    }

    .woowhatsorder-form {
        background: #fff;
        border-radius: 12px;
        padding: 30px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.05);
        margin-top: 20px;
    }

    .woowhatsorder-form-table th {
        width: 250px;
        padding: 20px 10px 20px 0;
        font-weight: 500;
        color: #1e1e1e;
    }

    .woowhatsorder-form-table td {
        padding: 15px 0;
    }

    .woowhatsorder-input {
        width: 100%;
        max-width: 400px;
        padding: 12px 15px;
        border: 1px solid #8c8f94;
        border-radius: 6px;
        font-size: 14px;
        transition: all 0.3s ease;
    }

    .woowhatsorder-input:focus {
        border-color: #3858e9;
        box-shadow: 0 0 0 2px rgba(56, 88, 233, 0.2);
        outline: none;
    }

    .woowhatsorder-description-text {
        color: #646970;
        font-size: 13px;
        margin-top: 8px;
        display: block;
    }

    .woowhatsorder-shortcode {
        background: #f6f7f7;
        padding: 4px 8px;
        border-radius: 4px;
        font-family: monospace;
        color: #d63638;
    }

    .button-primary {
        background: #3858e9;
        border-color: #2c4bd4;
        padding: 12px 25px;
        height: auto;
        border-radius: 6px;
        text-transform: uppercase;
        font-weight: 500;
        letter-spacing: 0.5px;
        transition: all 0.3s ease;
    }

    .button-primary:hover {
        background: #2c4bd4;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(56, 88, 233, 0.25);
    }

    @media screen and (max-width: 782px) {
        .woowhatsorder-wrap {
            padding: 20px 15px;
        }
        
        .woowhatsorder-form {
            padding: 20px;
        }
        
        .woowhatsorder-form-table th,
        .woowhatsorder-form-table td {
            display: block;
            width: 100%;
            padding: 10px 0;
        }
        
        .woowhatsorder-input {
            max-width: 100%;
        }
    }
</style>

<div class="woowhatsorder-wrap">
    <!-- Banner -->
    <div class="woowhatsorder-banner">
        <img src="https://elsaltoweb.es/wp-content/uploads/2025/05/woowhatsorder.webp" alt="Woo WhatsOrder Banner" />
    </div>

    <!-- Título -->
    <h1 class="woowhatsorder-title">Woo WhatsOrder – Ajustes del Plugin</h1>

    <!-- Descripción -->
    <p class="woowhatsorder-description">
        <strong>Woo WhatsOrder</strong> añade un botón de <strong>WhatsApp</strong> al finalizar una compra, para que tus clientes puedan enviarte el pedido directo por mensaje.
    </p>
    <p class="woowhatsorder-description" style="font-size: 14px;">
        También puedes usar el shortcode <code class="woowhatsorder-shortcode">[whatsapp_pedido]</code> para mostrar el botón en cualquier página.
    </p>

    <!-- Formulario de configuración -->
    <form method="post" action="options.php" class="woowhatsorder-form">
        <?php
        settings_fields('woo_whatsapp_settings_group');
        do_settings_sections('woo_whatsapp_settings_group');
        ?>
        <table class="form-table woowhatsorder-form-table">
            <tr valign="top">
                <th scope="row">
                    <label for="woo_whatsapp_number">Número de WhatsApp</label>
                </th>
                <td>
                    <input 
                        type="text" 
                        id="woo_whatsapp_number" 
                        name="woo_whatsapp_number" 
                        value="<?php echo esc_attr(get_option('woo_whatsapp_number', '34600111222')); ?>" 
                        placeholder="Ej: 34600111222" 
                        class="woowhatsorder-input" 
                    />
                    <span class="woowhatsorder-description-text">Introduce el número en formato internacional, sin "+" ni espacios.</span>
                </td>
            </tr>
        </table>

        <?php submit_button('Guardar cambios', 'primary', 'submit', true); ?>
    </form>
    <!-- Sección Premium -->
<div style="margin-top: 50px; background: #f3f4f6; border: 1px solid #dcdcdc; padding: 30px; border-radius: 12px;">
    <h2 style="font-size: 24px; font-weight: 600; color: #1e1e1e; margin-bottom: 15px;">
        🚀 Próximamente: Woo WhatsOrder Premium para Empresas
    </h2>
    <p style="color: #444; font-size: 15px; line-height: 1.7; max-width: 800px;">
        Estamos trabajando en una <strong>versión profesional</strong> del plugin con funcionalidades avanzadas para tiendas online que gestionan múltiples pedidos por WhatsApp:
    </p>
    <ul style="margin-top: 20px; margin-bottom: 20px; padding-left: 20px; color: #333; font-size: 14.5px; line-height: 1.8;">
        <li>✅ Mensajes automáticos personalizados según estado del pedido</li>
        <li>✅ Soporte multiagente para atención por equipos</li>
        <li>✅ Estadísticas y seguimiento de conversiones por WhatsApp</li>
        <li>✅ Integración con etiquetas UTM para campañas</li>
        <li>✅ Soporte prioritario y actualizaciones exclusivas</li>
    </ul>
    <p style="color: #444; font-size: 14.5px;">
        ¿Quieres ser de los primeros en probarla? <strong>Déjanos tu interés</strong> para recibir acceso anticipado y un descuento exclusivo:
    </p>
    <a href="https://elsaltoweb.es/contacto" target="_blank" style="display: inline-block; margin-top: 15px; background-color: #3858e9; color: white; padding: 12px 24px; border-radius: 6px; text-decoration: none; font-weight: 600;">
        💬 Avisadme cuando esté lista
    </a>
</div>

</div>
    <?php
}
